module Aufgabe6 where

-- tiefe

data PBinTree a = Empty | Node a (PBinTree a) (PBinTree a)

-- instance Eq PBinTree => Eq PBinTree where 
--   Empty  == Empty  = True
--   _      == _      = False


--  (a, aa) == (b, bb) = a == b && bb == bb

tiefe :: PBinTree a -> Integer
tiefe Empty = 0
tiefe (Node _ bt1 bt2) = 1 + max (tiefe bt1) (tiefe bt2)

istVollstaendig, istBalanciert, istPerfektBalanciert :: PBinTree a -> Bool
istVollstaendig Empty = True
istVollstaendig (Node _ Empty Empty) = True
istVollstaendig (Node _ Empty bt2) = False
istVollstaendig (Node _ bt1 Empty) = False
istVollstaendig (Node _ bt1 bt2) = (istVollstaendig bt1) && (istVollstaendig bt2) where
istPerfektBalanciert Empty = True
istPerfektBalanciert (Node _ Empty bt2) = istPerfektBalanciert bt2
istPerfektBalanciert (Node _ bt1 Empty) = istPerfektBalanciert bt1
istPerfektBalanciert (Node _ bt1 bt2) = istPerfektBalanciert bt1 && istPerfektBalanciert bt2 && (abs ((tiefe bt1) - (tiefe bt2))) == 0
istBalanciert Empty = True
istBalanciert (Node _ Empty bt2) = istBalanciert bt2
istBalanciert (Node _ bt1 Empty) = istBalanciert bt1
istBalanciert (Node _ bt1 bt2) = istBalanciert bt1 && istBalanciert bt2 && (abs ((tiefe bt1) - (tiefe bt2))) < 2

-- xor a b = (a && b) || ((not a) && (not b))


praeOrder, inOrder, postOrder :: PBinTree a -> [a]
praeOrder Empty = []
praeOrder (Node a bt1 bt2) = [a] ++ praeOrder bt1 ++ praeOrder bt2
inOrder Empty = []
inOrder (Node a bt1 bt2) = inOrder bt1 ++ [a] ++ inOrder bt2
postOrder Empty = []
postOrder (Node a bt1 bt2) = postOrder bt1 ++ postOrder bt2 ++ [a]


protokoll :: PBinTree String -> String
protokoll Empty = []
protokoll (Node a bt1 bt2) = protokoll bt2 ++ a ++ protokoll bt1

