/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */

/*
 *  Lexer for RPLD conf files
 *
 *  $Log: rpld_conf.lex,v $
 *  Revision 1.6  2000/07/17 10:43:34  root
 *  #
 *
 *  Revision 1.5  2000/07/16 14:05:28  root
 *  #
 *
 *  Revision 1.4  2000/07/16 13:18:10  root
 *  #
 *
 *  Revision 1.1  2000/07/16 13:16:33  root
 *  #
 *
 *  Revision 1.3  1999/09/13 11:17:35  root
 *  \#
 *
 *  Revision 1.2  1999/09/13 11:08:34  root
 *  \#
 *
 *  Revision 1.1  1999/09/13 11:04:13  root
 *  \#
 *
 *  Revision 1.10  1999/09/12 19:08:24  chris
 *  Another attempt at C comments.
 *
 *  Revision 1.9  1999/09/12 17:38:45  chris
 *  Implemented proper MAC reading.
 *
 *  Revision 1.8  1999/09/12 03:27:43  chris
 *  Changes to enable error reporting in yacc grammar.
 *
 *  Revision 1.7  1999/09/11 19:30:26  chris
 *  Fixed hex number support.
 *
 *  Revision 1.6  1999/09/11 19:25:06  chris
 *  No major changes.
 *
 *  Revision 1.5  1999/09/11 19:24:23  chris
 *  Removed support for C-style comments, inserted support for C++ ones. Comment support actually works now
 *
 *  Revision 1.4  1999/09/11 19:02:25  chris
 *  Fixed bug in comment support.
 *
 *  Revision 1.3  1999/09/11 19:00:43  chris
 *  Added support for comments.
 *
 *  Revision 1.2  1999/09/11 18:57:31  chris
 *  Initial revision.
 *
 *  
 */

%x	COMMENT

%{
static char rcsid[]="$Id: rpld_conf.lex,v 1.6 2000/07/17 10:43:34 root Exp $";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "rpld_conf.tab.h"


// line number
int lineno = 1;

// function to convert hex digits to a MAC address
void strtomac(char *s, char *mac);

void strtomac(char *s, char *mac)
{
	// mac address *must* be in form 00:11:22:33:44:55
	int i;

	for (i = 0; i < 6; i++) *(mac + i) = (unsigned char)strtol(s + i * 3, NULL, 16);
}


%}
ws	[ \t]+
nl	\n
hb	[0-9A-Fa-f][0-9A-Fa-f]

%%

{ws}			;
{nl}			{ lineno++; }

\/\/.*			;

"/*"			BEGIN COMMENT;
<COMMENT>.	|
<COMMENT>\n		;
<COMMENT>"*/"		BEGIN INITIAL;

[{]			{ return BLOCK_START; }

[}]			{ return BLOCK_END; }

{hb}:{hb}:{hb}:{hb}:{hb}:{hb}	{
				strtomac(yytext, (yylval.mac_address));
				return MACADDR;
			}

{hb}:{hb}:{hb}:{hb}:{hb}:{hb}/[1-6]	{
				strtomac(yytext, (yylval.pm.mac_address));
				yylval.pm.mac_len = yytext[13] - '0';
				return MACADDR_PARTIAL;
			}

0x[0-9A-Fa-f]+ {
				yylval.number = strtol(yytext + 2, NULL, 16);
				return NUMBER;
			}

[0-9]+			{
				int i; i = strtol(yytext, NULL, 10);
				yylval.number = i; return NUMBER;
			}

[A-Za-z\-_]+		{ yylval.name = strdup(yytext); return NAME; }

\"[A-Za-z0-9.:/\-_ ]*\"	{ yylval.text = strdup(yytext + 1); *(yylval.text + strlen(yylval.text) - 1) = 0; return TEXT;}

.			{ return yytext[0]; }

%%


int yywrap()
{
	return 1;
}

