/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] = "$Id: protocol.c,v 1.17 2000/07/23 19:07:49 root Exp $";

/*
 * $Log: protocol.c,v $
 * Revision 1.17  2000/07/23 19:07:49  root
 * #
 *
 * Revision 1.16  2000/07/17 11:59:45  root
 * #
 *
 * Revision 1.15  2000/07/17 10:49:20  root
 * #
 *
 * Revision 1.14  2000/07/17 10:45:38  root
 * #
 *
 * Revision 1.13  2000/07/17 10:43:54  root
 * #
 *
 * Revision 1.12  2000/07/17 10:43:34  root
 * #
 *
 * Revision 1.11  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.10  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.9  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.8  1999/09/13 11:08:34  root
 * \#
 *
 * Revision 1.7  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.6  1999/09/13 11:04:13  root
 * \#
 *
 */

#include "project.h"

/* Process the find frame and xmit a found frame */
void
find_frame (struct nit *n, struct rpl_packet *in)
{
  struct client *c;
  struct rpl_packet out;

  c = find_client_by_mac (in->mymac);

  if (!c)
    {
      syslog (LOG_ERR, "unknown client %s", ethtoa (in->mymac));
      return;
    }

  c->blocknum = 0;

  out.type = RPL_PK_FOUND;

  out.flags =
    RPL_FL_TMZ | RPL_FL_TSZ | RPL_FL_YOUMAC | RPL_FL_MYMAC | RPL_FL_FRAMELEN |
    RPL_FL_WHOAMI | RPL_FL_SAP;

  out.themightyzero = in->themightyzero;
  out.thesmallzero = 0;
  out.whoami = 0;

  if (in->framelen < c->framelen)
    {
      c->framelen = in->framelen;
    }

  if ((c->blocklen + LLC_RPL_OVERHEAD) > c->framelen)
    {
      c->blocklen = c->framelen - LLC_RPL_OVERHEAD;
      c->blocklen &= ~0x7;
    }

  c->framelen = out.framelen =
    (in->framelen > c->framelen) ? c->framelen : in->framelen;
  out.sap = RPL_SAP;

  bcopy (in->mymac, out.youmac, ETH_ALEN);
  bcopy (nit_mac (n), out.mymac, ETH_ALEN);

  c->state = ST_FIND;

  rpl_send_packet (n, c->mac, &out);

  c->state = ST_FOUND;

}


file_data_frame (struct nit *n, struct client *c)
{
  struct rpl_packet out;
  int i;

  u32 addr = 0x10000;

  if (c->state != ST_FILEDATA)
    return;

  out.flags = RPL_FL_BLOCK | RPL_FL_ADDR | RPL_FL_DATA;
  out.type = RPL_PK_FILEDATA;

  out.block = c->blocknum;

  client_get_block (c, &out);

  out.addr.run = c->run_addr;

#ifdef DEBUG
  printf ("block %5d, %4d bytes to 0x%08x\n", c->blocknum,
          out.datalen, out.addr.load);
#endif

  if (client_last_block (c))
    {
      out.addr.flags = RPL_AD_FLAGS_DONE;
      c->state = ST_DONE;
#ifdef DEBUG
      printf ("Last block - transfering control to 0x%08x\n", c->run_addr);
#endif
      clients_check_status ();
    }
  else
    {
      out.addr.flags = RPL_AD_FLAGS_MORE;
    }



  rpl_send_packet (n, c->mac, &out);
  c->blocknum++;

  return (i);
}

void
send_file_frame (struct nit *n, struct rpl_packet *in)
{
  struct client *c;
  struct rpl_packet out;

  c = find_client_by_mac (in->mymac);

  if (!c)
    {
      printf ("Unknown client\n");
      return;
    }

  c->state = ST_SENDFILE;

  c->blocknum = in->block;
  c->framelen = in->framelen;

  syslog (LOG_ERR, "client %s requested block %d", ethtoa (c->mac),
          c->blocknum);

  client_calc_offsets (c);

  c->state = ST_FILEDATA;

  clients_check_status ();      /* This will upgrade our condition to downloading */


  if (c->nospew)
    file_data_frame (n, c);


}

/* rpl.c call this after it's interpreted a packet from the nic */
void
rpl_packet_recvd_callback (struct nit *n, struct rpl_packet *p)
{
  switch (p->type)
    {
    case RPL_PK_FIND:

      if ((p->flags & RPL_FIND_FLAGS) == RPL_FIND_FLAGS)
        {
          find_frame (n, p);
        }
      else
        {
          syslog (LOG_ERR, "Incomplete FIND frame 0x%x vs 0x%x\n",
                  p->flags, RPL_FIND_FLAGS);
        }
    case RPL_PK_FOUND:         /*We're not a client */
      break;
    case RPL_PK_SENDFILE:
      if ((p->flags & RPL_SEND_FILE_FLAGS) == RPL_SEND_FILE_FLAGS)
        {
          send_file_frame (n, p);
        }
      else
        {
          syslog (LOG_ERR,
                  "Incomplete SEND.FILE.REQUEST frame 0x%x vs 0x%x\n",
                  p->flags, RPL_SEND_FILE_FLAGS);
        }
      break;
    case RPL_PK_FILEDATA:      /*We're not a client */
      break;
    default:
      syslog (LOG_ERR, "Unknown RPL packet type 0x%04x\n", p->type);

    }

}
