/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] = "$Id: llc.c,v 1.10 2000/07/17 11:59:45 root Exp $";

/*
 * $Log: llc.c,v $
 * Revision 1.10  2000/07/17 11:59:45  root
 * #
 *
 * Revision 1.9  2000/07/17 10:43:34  root
 * #
 *
 * Revision 1.8  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.7  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.6  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.5  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.4  1999/09/13 11:04:13  root
 * \#
 *
 */



#include "project.h"

void
send_llc_frame (struct nit *n, unsigned char dsap, unsigned char ssap,
                unsigned char *dmac, unsigned char *ibuf, int len)
{
  unsigned char buf[MAX_FRAME_LEN];
  struct llchdr *h = (struct llchdr *) buf;

  bcopy (dmac, h->h_dest, ETH_ALEN);
  bcopy (nit_mac (n), h->h_source, ETH_ALEN);

  h->h_len = htons (len + LLC_SAP_LEN);

  h->h_dsap = dsap;
  h->h_ssap = ssap;
  h->h_flags = LLC_UIC;

  bcopy (ibuf, buf + LLC_HDR_LEN, len);

  len += LLC_HDR_LEN;
  nit_send_frame (n, buf, len);
}

void
llc_recv_packet (struct nit *n, unsigned char *buf, int len)
{
  struct llchdr *h = (struct llchdr *) buf;
  int llclen;

  if ((h->h_dsap == RPL_SAP) && (h->h_ssap == RPL_SAP))
    {

      llclen = ntohs (h->h_len);

#ifdef DEBUG
      printf ("dest: %s ", ethtoa (&h->h_dest));
      printf ("source: %s ", ethtoa (&h->h_source));
      printf ("len: 0x%04x ", llclen);
      printf ("dsap:%02x ssap:%02x flags:%02x \n", h->h_dsap, h->h_ssap,
              h->h_flags);
#endif

      rpl_packet_recvd (n, buf + LLC_HDR_LEN, llclen - LLC_SAP_LEN);

    }

}
