
#ifndef mmioFOURCC
#define mmioFOURCC( ch0, ch1, ch2, ch3 )                                \
                ( (ch0&0xff) | ( (ch1&0xff) << 8 ) |    \
		  ( (ch2&0xff) << 16 ) | ( (ch3&0xff) << 24 ) )
#endif
	
#include <stdio.h>
#include <stdlib.h>
#include "colormodels.h"
#include "config.h"
#ifdef DYNAMIC_LOADING
#define GLOBAL_ /* used by global.h, supposed to occur once */
#endif
#include "global.h"
#include "aviplugin.h"

#include <avifile/default.h>

#ifndef fccYUY2
#include <fourcc.h>
#endif

void conv444to422(src,dst);

#ifdef DYNAMIC_LOADING
void read_avi(unsigned char **frame, unsigned int number);

void video_in(){}

void read_frame(unsigned char *frame[], unsigned int number)
{
	read_avi(frame,number);
}
#endif

void read_avi(frame, number)
unsigned char *frame[];
unsigned int number;
{
  int i, j;
  int r, g, b;
  double y, u, v;
  double cr, cg, cb, cu, cv;
  char name[128];
  unsigned char *p_image, **pp_image;
  unsigned char *yp, *up, *vp;
  static unsigned char *u444, *v444, *u422, *v422;
  static unsigned int outputtype;
  static double coef[7][3] = {
    {0.2125,0.7154,0.0721}, /* ITU-R Rec. 709 (1990) */
    {0.299, 0.587, 0.114},  /* unspecified */
    {0.299, 0.587, 0.114},  /* reserved */
    {0.30,  0.59,  0.11},   /* FCC */
    {0.299, 0.587, 0.114},  /* ITU-R Rec. 624-4 System B, G */
    {0.299, 0.587, 0.114},  /* SMPTE 170M */
    {0.212, 0.701, 0.087}}; /* SMPTE 240M (1987) */
  char buf[32];
  static int   mostrecentp = 0;
  static int    mostrecent = 0;
  static size_t    bufsize;
  static int avi_read_width, avi_read_height;

  i = matrix_coefficients;
  if (i>8)
    i = 3;

  cr = coef[i-1][0];
  cg = coef[i-1][1];
  cb = coef[i-1][2];
  cu = 0.5/(1.0-cb);
  cv = 0.5/(1.0-cr);

  if (!outputtype) {
  	outputtype=avi_outputtype();
#ifdef DYNAMIC_LOADING
	avi_read_width=get_video_width();
	avi_read_height=get_video_height();
#else
	avi_read_width=avi_video_width();
	avi_read_height=avi_video_height();
#endif
	fprintf(stderr,"\noutput format %c%c%c%c\n\n",(outputtype&0xff),(outputtype&0xff00)>>8,(outputtype&0xff0000)>>16, (outputtype&0xff000000)>>24);
  }
  if (outputtype==mmioFOURCC('R','G','B','A')) {
    if (chroma_format==CHROMA444) {
      u444 = frame[1];
      v444 = frame[2];
    } else {
      if (!u444) {
        if (!(u444 = (unsigned char *)malloc(avi_read_width*avi_read_height)))
          error("malloc failed");
        if (!(v444 = (unsigned char *)malloc(avi_read_width*avi_read_height)))
          error("malloc failed");
        if (chroma_format==CHROMA420) {
          if (!(u422 = (unsigned char *)malloc((avi_read_width>>1)*avi_read_height)))
            error("malloc failed");
          if (!(v422 = (unsigned char *)malloc((avi_read_width>>1)*avi_read_height)))
            error("malloc failed");
        }
      }
    }

    p_image = avi_get_frame(number);
  
    for (i=0; i<avi_read_height ; i++) {
      yp = frame[0] + i*avi_read_width;
      up = u444 + i*avi_read_width;
      vp = v444 + i*avi_read_width;

      for (j=0; j<avi_read_width ; j++) {
        b=*p_image++;
        g=*p_image++; 
        r=*p_image++; 

        /* g = r = b = ( g + r + b )/3; */

        /* convert to YUV */
        y = cr*r + cg*g + cb*b;
        u = cu*(b-y);
        v = cv*(r-y);
        yp[j] = (219.0/256.0)*y + 16.5;  /* nominal range: 16..235 */
        up[j] = (224.0/256.0)*u + 128.5; /* 16..240 */
        vp[j] = (224.0/256.0)*v + 128.5; /* 16..240 */
      }
    }

//  border_extend(frame[0],avi_read_width,avi_read_height,avi_read_width,avi_read_height);
//  border_extend(u444,avi_read_width,avi_read_height,avi_read_width,avi_read_height);
//  border_extend(v444,avi_read_width,avi_read_height,avi_read_width,avi_read_height);

    if (chroma_format==CHROMA422) {
      conv444to422(u444,frame[1]);
      conv444to422(v444,frame[2]);
    }

    if (chroma_format==CHROMA420) {
      conv444to422(u444,u422);
      conv444to422(v444,v422);
      conv422to420(u422,frame[1]);
      conv422to420(v422,frame[2]);
    }
  } else if (outputtype==fccYUY2) {
    p_image = avi_get_frame(number);
    yp=frame[0];
    up=frame[1];
    vp=frame[2];
		  
    for (i=0; i<avi_read_height; i++) {
      if (i%2) {
	  up-=avi_read_width/2;
	  vp-=avi_read_width/2;
	  for (j=0; j<avi_read_width; j+=2) {
		  *yp++=*p_image++;
  		  *up++=((*p_image++)+(*up))>>1;
		  *yp++=*p_image++;
  		  *vp++=((*p_image++)+(*vp))>>1;
	  }
      } else {
	  for (j=0; j<avi_read_width; j+=2) {
		  *yp++=*p_image++;
  		  *up++=*p_image++;
		  *yp++=*p_image++;
  		  *vp++=*p_image++;
	  }
      }
    }
//  conv422to420(u422,frame[1]);
//  conv422to420(v422,frame[2]);
	  
  } else if (outputtype==fccIYUV) {
    p_image = avi_get_frame(number);
    memcpy(frame[0],p_image,avi_read_width*avi_read_height);
    memcpy(frame[1],p_image+avi_read_width*avi_read_height,avi_read_width*avi_read_height/4);
    memcpy(frame[2],p_image+avi_read_width*avi_read_height+avi_read_width*avi_read_height/4,avi_read_width*avi_read_height/4);
  } else if (outputtype==fccYV12) {
    p_image = avi_get_frame(number);
    memcpy(frame[0],p_image,avi_read_width*avi_read_height);
    memcpy(frame[1],p_image+avi_read_width*avi_read_height,avi_read_width*avi_read_height/4);
    memcpy(frame[2],p_image+avi_read_width*avi_read_height+avi_read_width*avi_read_height/4,avi_read_width*avi_read_height/4);
  } else {
    fprintf(stderr,"unsupported output format\n");
  }
#ifndef DYNAMIC_LOADING
  if(avi_end_of_video()) frames_scaled = 0; /* Terminate encoding */
#endif
}
