/* time/framestamping code courtesy of sid (Andreas Varga) */

#include <stdio.h>
#include <stdlib.h>
#include "colormodels.h"
#include "config.h"
#include "global.h"
#include "aviplugin.h"
#include "../rtjpeg/RTjpeg.h"
#include "areaDeinterlace.h"
#include <avifile/default.h>

static int framenum = 0;

char font[10][5][5] = {
  { // 0
    { 0x00,0xff,0xff,0x00,0x00 },
    { 0xff,0x00,0x00,0xff,0x00 },
    { 0xff,0x00,0x00,0xff,0x00 },
    { 0xff,0x00,0x00,0xff,0x00 },
    { 0x00,0xff,0xff,0x00,0x00 },
  },
  { // 1
    { 0x00,0x00,0x00,0xff,0x00 },
    { 0x00,0x00,0xff,0xff,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
  },
  { // 2
    { 0x00,0xff,0xff,0x00,0x00 },
    { 0xff,0x00,0x00,0xff,0x00 },
    { 0x00,0xff,0xff,0x00,0x00 },
    { 0xff,0x00,0x00,0x00,0x00 },
    { 0xff,0xff,0xff,0xff,0x00 },
  },
  { // 3
    { 0xff,0xff,0xff,0x00,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
    { 0x00,0x00,0xff,0x00,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
    { 0xff,0xff,0xff,0xff,0x00 },
  },
  { // 4
    { 0x00,0x00,0xff,0xff,0x00 },
    { 0x00,0xff,0x00,0xff,0x00 },
    { 0xff,0xff,0xff,0xff,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
  },
  { // 5
    { 0xff,0xff,0xff,0xff,0x00 },
    { 0xff,0x00,0x00,0x00,0x00 },
    { 0xff,0xff,0xff,0x00,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
    { 0xff,0xff,0xff,0x00,0x00 },
  },
  { // 6
    { 0x00,0xff,0xff,0xff,0x00 },
    { 0xff,0x00,0x00,0x00,0x00 },
    { 0xff,0xff,0xff,0x00,0x00 },
    { 0xff,0x00,0x00,0xff,0x00 },
    { 0x00,0xff,0xff,0x00,0x00 },
  },
  { // 7
    { 0x00,0xff,0xff,0xff,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
    { 0x00,0x00,0xff,0xff,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
  },
  { // 8
    { 0x00,0xff,0xff,0x00,0x00 },
    { 0xff,0x00,0x00,0xff,0x00 },
    { 0x00,0xff,0xff,0x00,0x00 },
    { 0xff,0x00,0x00,0xff,0x00 },
    { 0x00,0xff,0xff,0xff,0x00 },
  },
  { // 9
    { 0x00,0xff,0xff,0x00,0x00 },
    { 0xff,0x00,0x00,0xff,0x00 },
    { 0x00,0xff,0xff,0xff,0x00 },
    { 0x00,0x00,0x00,0xff,0x00 },
    { 0xff,0xff,0xff,0x00,0x00 },
  }
};

void timestamp (uint8_t *yuv[], char *stamp)
{
  /* sid macht framenummern als graphix hinein */
  int xpos,ypos,f,tmp;
  unsigned char *dst = NULL;
  int         chrom_hsize = (chroma_format == CHROMA444) ? horizontal_size*2
                                               : horizontal_size/*>>1*/;


  for ( f = 0; f < strlen( stamp ); f++ ) {

   if (stamp[f]>=0x30 && stamp[f]<0x3a ) { // only numbers in the font yet
    for ( ypos = 0; ypos < 5; ypos++ ) {

      for ( xpos = 0; xpos < 5; xpos++ ) {
      tmp = font[stamp[f]-48][ypos][xpos];
          dst = yuv[0] + ypos*2*chrom_hsize/* *3 */ + 2*5 /* *3 */ *f+xpos*2;
        *dst++ = tmp;
        *dst++ = tmp;
          dst = yuv[0] + (ypos*2+1)*chrom_hsize/* *3 */ + 2*5 /* *3 */ *f+xpos*2;
        *dst++ = tmp;
        *dst++ = tmp;
          dst = yuv[1] + ypos*chrom_hsize/2 + 5 /* *3 */ *f+xpos;
        *dst++ = 0x7f;
          dst = yuv[2] + ypos*chrom_hsize/2 + 5 /* *3 */ *f+xpos;
        *dst++ = 0x7f;
      }

    }
   }
  }
}
