/* nuppelvideo.h  rh */

typedef struct rtfileheader
{
  char finfo[12];     // "NuppelVideo" + \0
  char version[5];    // "0.03" + \0
  int  width;
  int  height;
  int  desiredwidth;  // 0 .. as it is
  int  desiredheight; // 0 .. as it is
  char pimode;        // P .. progressive
		      // I .. interlaced  (2 half pics) [NI]
  double aspect;      // 1.0 .. square pixel (1.5 .. e.g. width=480: width*1.5=720
                      // for capturing for svcd material
  double fps;
  long videoblocks;   // count of video-blocks -1 .. unknown   0 .. no video
  long audioblocks;   // count of audio-blocks -1 .. unknown   0 .. no audio
  long textsblocks;   // count of text-blocks  -1 .. unknown   0 .. no text
} rtfileheader;

typedef struct rtframeheader
{
   char frametype;			// A .. Audio, V .. Video, S .. Sync, T .. Text
   					// R .. Seekpoint: String RTjjjj (use full packet)
					// D .. Addition Data for Copressors
   					//      ct: R .. RTjpeg Tables

   char comptype;			// V: 0 .. Uncompressed [NI]
					//    1 .. RTJpeg
					//    2 .. RTJpeg with lzo afterwards
					//    N .. black frame
					//    L .. simply copy last frame (if lost frames)
    					// A: 0 .. Uncompressed (44100/sec 16bit 2ch)
    					//    1 .. lzo compression [NI]
    					//    2 .. layer2 (packet) [NI]
    					//    2 .. layer3 (packet) [NI]
    					//    3 .. layer3 (packet) [NI]
    					//    F .. flac (lossless) [NI]
    					//    S .. shorten (lossless) [NI]
					//    N .. null frame loudless
					//    L .. simply copy last frame (may sound bad)
					// S: A .. Next Audio Sync [NI]
					//    V .. Next Audio Sync [NI]
					//    S .. Audio,Video,Text Correlation [NI]

   int  packetlength;                   // V,A,T: length of following data in stream [NI]
   					//     S: V,A: packet number of last audio/video packet [NI]
   					//     S: V,A: packet number of last audio/video packet [NI]
   					//     S: S:   length of packet correl. information [NI]
   					//     R: do not use here! (fixed 'jjjj')  [NI]
} rtframeheader;

typedef struct vidbuffertype
{
    long long sample;
    int freeToEncode;
    int freeToBuffer;
    unsigned char *buffer_offset;
} vidbuffertyp;

typedef struct audbuffertype
{
    long long sample;
    int freeToEncode;
    int freeToBuffer;
    unsigned char *buffer_offset;
} audbuffertyp;

