/* areaBasedDeinterlace.c for YUV420 frames                     */
/* 2001/03/01 (c)Roman Hochleitner <roman@mars.tuwien.ac.at>    */
/* last changed 2001/03/01                                      */
/*                                                              */
/* based on the Area Based Deinterlacer (for RGB frames)        */
/* (a VirtualDub filter) from Gunnar Thalin <guth@home.se>      */
/*                                                              */
/* licensed under the GNU Public License (GPL) v2               */

#include <stdio.h>
#include <stdlib.h>
#include "colormodels.h"
#include "config.h"
#include "global.h"
#include "../rtjpeg/RTjpeg.h"

typedef struct MyFilterData
{
  int bShowDeinterlacedAreaOnly;
  int bBlend;
  // int iThresholdBlend; // here we start blending
  int iThreshold;         // here we start interpolating TODO FIXME
  int iEdgeDetect;
}
MyFilterData;


MyFilterData myfd;

int
InitProc ()
{
  myfd.bShowDeinterlacedAreaOnly = 0;

  myfd.bBlend = 0;
  // myfd->bBlend = 1; there should be a another threshold for us to know from which
  // threshold to begin with blending up to the next when we start interpolating
  // that would give us much better results and  better resolution within the
  // interlacing area
  

  // myfd.iThreshold  = 27;
  myfd.iThreshold  = 50;
  myfd.iEdgeDetect = 25;

  return 0;
}

/////////////////////////////////////////////
// and now the YUV420 deinterlacer

int AreaBasedDeinterlacerYUV420(unsigned char *yuvptr, int width, int height)
{
  int bShowDeinterlacedAreaOnly = myfd.bShowDeinterlacedAreaOnly;
  int y0, y1, y2, y3;
  unsigned char *psrc1, *psrc2, *psrc3, *pdst1;
  int iInterlaceValue0, iInterlaceValue1, iInterlaceValue2;
  int x, y;
  int y_line;

  // with initialization

  static int picsize = 0;
  static unsigned char *src = 0;

  unsigned char *y_dst, *y_src;

  int bBlend = myfd.bBlend;
  int iThreshold = myfd.iThreshold;
  int iEdgeDetect = myfd.iEdgeDetect;

  InitProc();

  if (picsize != (width*height)) {
    if (src) free(src);
    picsize = width*height; // only width*height because we only need to save Y
    src = malloc(picsize);
  }
  memcpy(src, yuvptr, picsize); // now copy the real source (which will be overwritten)
                             // to src (our buffer)

  y_dst = yuvptr;                     // dst y pointer
                   // we should not change u,v because one u, v value stands for
                   // 2 pixels per 2 lines = 4 pixel and we don't want to change
                   // the color of

  y_line  = width;
  y_src = src;


  iThreshold = iThreshold * iThreshold * 4;
  // We don't want an integer overflow in the  interlace calculation.
  if (iEdgeDetect > 180)
    iEdgeDetect = 180;
  iEdgeDetect = iEdgeDetect * iEdgeDetect;

  y1 = 0;		// Avoid compiler warning. The value is not used.
  for (x = 0; x < width; x++) {
      psrc3 = y_src + x;
      y3    = *psrc3;
      psrc2 = psrc3 + y_line;
         y2 = *psrc2;
      pdst1 = y_dst + x;
      iInterlaceValue1 = iInterlaceValue2 = 0;
      for (y = 0; y <= height; y++) {
	  psrc1 = psrc2;
	  psrc2 = psrc3;
	  psrc3 = psrc3 + y_line;
	  y0 = y1;
	  y1 = y2;
	  y2 = y3;
	  if (y < height - 1) {
	      y3 = *psrc3;
	  } else {
	      y3 = y1;
	  }

	  iInterlaceValue0 = iInterlaceValue1;
	  iInterlaceValue1 = iInterlaceValue2;

	  if (y < height)
	    iInterlaceValue2 = ((y1 - y2) * (y3 - y2) - 
                               ((iEdgeDetect * (y1 - y3) * (y1 - y3)) >> 12))*10;
	  else
	    iInterlaceValue2 = 0;

	  if (y > 0) {			
	    if (iInterlaceValue0 + 2 * iInterlaceValue1 + iInterlaceValue2 > iThreshold) {
              if (bBlend) { 
                *pdst1 = (unsigned char)((y0 + 2*y1 + y2) >> 2);
              } else {
                // this method seems to work better than blending if the
                // quality is pretty bad and the half pics don't fit together
                if ((y % 2)==1) {  // if odd simply copy the value
                  *pdst1 = *psrc1;
                  //*pdst1 = 0; // FIXME this is for adjusting an initial iThreshold
                } else {        // even interpolate the even line (upper + lower)/2
                  *pdst1 = (unsigned char)((y0 + y2) >> 1);
                  //*pdst1 = 0; // FIXME this is for adjusting an initial iThreshold
                }
              } 
            } else {
              // so we went below the treshold and therefore we don't have to 
              // change anything
              if (bShowDeinterlacedAreaOnly) {
                // this is for testing to see how we should tune the treshhold
                // and shows as the things that haven't change because the 
                // threshhold was to low?? (or shows that everything is ok :-)
                *pdst1 = 0; // blank the point and so the interlac area
              } else {
                *pdst1 = *psrc1;
              }
            }
	    pdst1 = pdst1 + y_line;
	  }
	}
    }

  return 0;
}
