#ifndef f_VIDEOSOURCE_H
#define f_VIDEOSOURCE_H

#include <windows.h>
#include <vfw.h>

#include "DubSource.h"

class AVIStripeSystem;
class AVIStripeIndexLookup;
class IMJPEGDecoder;
class IAVIReadHandler;
class IAVIReadStream;

class VideoSource : public DubSource {
protected:
	HANDLE		hBufferObject;
	LONG		lBufferOffset;
	void		*lpvBuffer;
	BITMAPINFOHEADER *bmihDecompressedFormat;
	long		stream_desired_frame;
	long		stream_current_frame;

	void *AllocFrameBuffer(long size);
	void FreeFrameBuffer();

	VideoSource();

public:
	enum {
		IFMODE_NORMAL		=0,
		IFMODE_SWAP			=1,
		IFMODE_SPLIT1		=2,
		IFMODE_SPLIT2		=3,
		IFMODE_DISCARD1		=4,
		IFMODE_DISCARD2		=5,
	};

	virtual ~VideoSource();

	BITMAPINFOHEADER *getImageFormat() const {
		return (BITMAPINFOHEADER *)getFormat();
	}

	void *getFrameBuffer() {
		return lpvBuffer;
	}

	HANDLE getFrameBufferObject() {
		return hBufferObject;
	}

	LONG getFrameBufferOffset() {
		return lBufferOffset;
	}

	virtual bool setDecompressedFormat(int depth);
	virtual bool setDecompressedFormat(BITMAPINFOHEADER *pbih);

	BITMAPINFOHEADER *getDecompressedFormat() {
		return bmihDecompressedFormat;
	}

	virtual void streamSetDesiredFrame(long frame_num);
	virtual long streamGetNextRequiredFrame(BOOL *is_preroll);
	virtual int	streamGetRequiredCount(long *pSize);
	virtual void *streamGetFrame(void *inputBuffer, long data_len, BOOL is_key, BOOL is_preroll, long frame_num) = NULL;

	virtual void streamBegin(bool fRealTime);

	virtual void invalidateFrameBuffer();
	virtual	BOOL isFrameBufferValid() = NULL;

	virtual void *getFrame(LONG frameNum) = NULL;

	virtual char getFrameTypeChar(long lFrameNum) = 0;
};

class VideoSourceAVI : public VideoSource {
private:
	IAVIReadHandler *pAVIFile;
	IAVIReadStream *pAVIStream;
	HIC			hicDecomp, hicDecomp2;
	LONG		lLastFrame;
	BITMAPINFOHEADER *bmihTemp;
	BOOL		use_ICDecompressEx;

	AVIStripeSystem			*stripesys;
	IAVIReadHandler			**stripe_files;
	IAVIReadStream			**stripe_streams;
	AVIStripeIndexLookup	*stripe_index;
	int						stripe_count;

	IMJPEGDecoder *mdec;
	HBITMAP		hbmLame;
	bool		fUseGDI;
	bool		fAllKeyFrames;

	IAVIReadStream *format_stream;

	char		*key_flags;
	bool		use_internal;
	int			mjpeg_mode;
	void		*mjpeg_reorder_buffer;
	int			mjpeg_reorder_buffer_size;
	long		*mjpeg_splits;
	long		mjpeg_last;
	long		mjpeg_last_size;
	FOURCC		fccForceVideo;

	void _construct();
	void _destruct();

public:
	VideoSourceAVI(IAVIReadHandler *pAVI, AVIStripeSystem *stripesys=NULL, IAVIReadHandler **stripe_files=NULL, bool use_internal=false, int mjpeg_mode=0, FOURCC fccForceVideo=0);
	~VideoSourceAVI();

	void Reinit();
	void redoKeyFlags();

	int _read(LONG lStart, LONG lCount, LPVOID lpBuffer, LONG cbBuffer, LONG *lBytesRead, LONG *lSamplesRead);
	BOOL _isKey(LONG samp);
	LONG nearestKey(LONG lSample);
	LONG prevKey(LONG lSample);
	LONG nextKey(LONG lSample);

	bool setDecompressedFormat(int depth);
	bool setDecompressedFormat(BITMAPINFOHEADER *pbih);
	void invalidateFrameBuffer();
	BOOL isFrameBufferValid();
	bool isStreaming();

	void streamBegin(bool fRealTime);
	void *streamGetFrame(void *inputBuffer, long data_len, BOOL is_key, BOOL is_preroll, long frame_num);
	void streamEnd();

	void *getFrame(LONG frameNum);

	HIC	getDecompressorHandle() const { return hicDecomp; }
	bool isUsingInternalMJPEG() const { return !!mdec; }

	char getFrameTypeChar(long lFrameNum);
};

#endif
