#ifndef f_DDRAWSUP_H
#define f_DDRAWSUP_H

#include <windows.h>
#include <objbase.h>

DECLARE_INTERFACE(IDirectDraw2);
DECLARE_INTERFACE(IDirectDrawClipper);
DECLARE_INTERFACE(IDirectDrawSurface);

class VBitmap;

bool DDrawDetect();
BOOL DDrawInitialize(HWND);
void DDrawDeinitialize();
IDirectDraw2 *DDrawObtainInterface();
IDirectDrawSurface *DDrawObtainPrimary();

class __declspec(novtable) IDDrawSurface {
public:
	virtual ~IDDrawSurface() {}
	virtual bool Lock(VBitmap *pvbm)=0;
	virtual bool LockInverted(VBitmap *pvbm)=0;
	virtual void Unlock()=0;
	virtual void SetColorKey(COLORREF rgb)=0;
	virtual void MoveOverlay(long x, long y)=0;
	virtual void SetOverlayPos(RECT *pr)=0;

	virtual IDirectDrawSurface *getSurface()=0;
};

IDDrawSurface *CreateDDrawSurface(IDirectDrawSurface *lpdds);

#endif
