#ifndef f_ASYNCBLITTER_H
#define f_ASYNCBLITTER_H

#include <windows.h>
#include <vfw.h>
#include <ddraw.h>

class IDDrawSurface;

class AsyncBlitRequestDrawDib {
public:
	HDRAWDIB hdd;
	HDC		hdc;
	int		xDst, yDst;
	int		dxDst, dyDst;
	LPBITMAPINFOHEADER lpbi;
	LPVOID	lpBits;
	int		xSrc;
	int		ySrc;
	int		dxSrc;
	int		dySrc;
	UINT	wFlags;
};

class AsyncBlitRequestStretchBlt {
public:
	HDC		hdcDst;
	int		xDst, yDst;
	int		dxDst, dyDst;
	HDC		hdcSrc;
	int		xSrc, ySrc;
	int		dxSrc, dySrc;
};

class AsyncBlitRequestStretchDIBits {
public:
	HDC		hdc;
	int		xDst, yDst, dxDst, dyDst;
	int		xSrc, ySrc, dxSrc, dySrc;
	const void	*pBits;
	const BITMAPINFO *pBitsInfo;
	UINT	iUsage;
	DWORD	dwRop;
};

class AsyncBlitRequestDirectDrawCopy {
public:
	void	*data;
	BITMAPINFOHEADER *pbih;
	IDDrawSurface *pDest;
};

class AsyncBlitRequestDirectDrawBlit {
public:
	IDDrawSurface *pSrc;
	IDirectDrawSurface *pDest;
	RECT r;
};

class AsyncBlitRequestICDraw {
public:
	HIC hic;
	DWORD dwFlags;
	LPVOID pFormat;
	LPVOID pData;
	DWORD cbData;
	LONG lTime;
};

class AsyncBlitRequest {
public:
	enum {
		REQTYPE_DRAWDIB,
		REQTYPE_STRETCHBLT,
		REQTYPE_DIRECTDRAWCOPY,
		REQTYPE_DIRECTDRAWBLIT,
		REQTYPE_ICDRAW,
		REQTYPE_STRETCHDIBITS,
	} type;
	DWORD	bufferID;
	DWORD	framenum;

	union {
		AsyncBlitRequestDrawDib	drawdib;
		AsyncBlitRequestStretchBlt stretchblt;
		AsyncBlitRequestDirectDrawCopy	ddcopy;
		AsyncBlitRequestDirectDrawBlit	ddblit;
		AsyncBlitRequestICDraw	icdraw;
		AsyncBlitRequestStretchDIBits stretchdibits;
	};
};

class AsyncBlitter {
private:
	AsyncBlitRequest *requests;
	int max_requests;

	volatile HANDLE	hThreadDraw;
	HANDLE			hEventDraw;
	HANDLE			hEventDrawReturn;
	HANDLE			hEventAbort;
	volatile DWORD	dwLockedBuffers;
	DWORD			dwPulseFrame;
	DWORD			dwDrawFrame;
	volatile BOOL	fAbort;
	BOOL			fPulsed;

	int		(*pulseCallback)(void *, DWORD);
	void	*pulseCallbackData;

	void release(DWORD);
	BOOL waitPulse(DWORD);
	static void drawThread(void *);
	void DoRequest(AsyncBlitRequest *req);
	void drawThread2();

public:
	AsyncBlitter();
	AsyncBlitter(int max_requests);
	~AsyncBlitter();

	enum {
		PCR_OKAY,
		PCR_NOBLIT,
		PCR_WAIT,
	};

#ifdef _DEBUG
	enum {
		LOCK_NONE		= 0,
		LOCK_DESTROY	= 0x00000001L,
		LOCK_LOCK		= 0x00000002L,
		LOCK_PULSE		= 0x00000004L,
		LOCK_POST		= 0x00000008L,
		LOCK_ASYNC_EXIT	= 0x00000010L,
	};
	
	volatile long lock_state;
#endif

	void enablePulsing(BOOL);
	void setPulseCallback(int (*pc)(void *, DWORD), void *pcd);
	void pulse();
	void setPulseClock(DWORD clk);
	void lock(DWORD);
	void unlock(DWORD);
	void nextFrame(long adv=1);
	long getFrameDelta();
	void post(DWORD, HDRAWDIB, HDC, int, int, int, int, LPBITMAPINFOHEADER, LPVOID, int, int, int, int, UINT);
	void postStretchBlt(DWORD id, HDC hdcDest, int xDst, int yDst, int dxDst, int dyDst, HDC hdcSrc, int xSrc, int ySrc, int dxSrc, int dySrc);
	void postStretchDIBits(DWORD id, HDC hdc, int xDst, int yDst, int dxDst, int dyDst, int xSrc, int ySrc, int dxSrc, int dySrc, const void *pBits, const BITMAPINFO *pBitsInfo, UINT iUsage, DWORD dwRop);
	void postDirectDrawCopy(DWORD id, void *data, BITMAPINFOHEADER *pbih, IDDrawSurface *pDest);
	void postDirectDrawBlit(DWORD id, IDirectDrawSurface *pDst, IDDrawSurface *pSrc, int xDst, int yDst, int dxDst, int dyDst);
	void postICDraw(DWORD id, HIC hic, DWORD dwFlags, LPVOID pFormat, LPVOID pData, DWORD cbData, LONG lTime);
	void abort();

	bool ServiceRequests(bool fWait);
};

#endif
