#ifndef f_AVIOUTPUTPREVIEW_H
#define f_AVIOUTPUTPREVIEW_H

#include "AVIOutput.h"
#include "AVIAudioOutput.h"

class AVIAudioPreviewOutputStream : public AVIAudioOutputStream {
private:
	AVIAudioOutput *myAudioOut;
	BOOL initialized, started;
	bool fInitialized;

	bool initAudio();
public:
	AVIAudioPreviewOutputStream(AVIOutput *out);
	~AVIAudioPreviewOutputStream();

	BOOL init();
	BOOL write(LONG dwIndexFlags, LPVOID lpBuffer, LONG cbBuffer, LONG lSamples);
	void start();
	BOOL finalize();
	BOOL flush();
	long getPosition();
	bool isFrozen();
	BOOL isSilent();
	void stop();
};

class AVIVideoPreviewOutputStream : public AVIVideoOutputStream {
public:
	AVIVideoPreviewOutputStream(AVIOutput *out) : AVIVideoOutputStream(out) { };

	BOOL write(LONG dwIndexFlags, LPVOID lpBuffer, LONG cbBuffer, LONG lSamples);
};

class AVIOutputPreview : public AVIOutput {
private:
public:
	AVIOutputPreview();
	~AVIOutputPreview();

	BOOL initOutputStreams();
	BOOL init(const char *szFile, LONG xSize, LONG ySize, BOOL videoIn, BOOL audioIn, LONG bufferSize, BOOL is_interleaved);
	BOOL finalize();
	BOOL isPreview();

	void writeIndexedChunk(FOURCC ckid, LONG dwIndexFlags, LPVOID lpBuffer, LONG cbBuffer);
};

#endif
