#ifndef f_AVIOUTPUT_IMAGES_H
#define f_AVIOUTPUT_IMAGES_H

#include <windows.h>
#include <vfw.h>

class VideoSource;

class AVIOutputImages : public AVIOutput {
private:
	char szFormat[MAX_PATH];
	int iDigits;

public:
	AVIOutputImages(char *szFormat, int iDigits);
	~AVIOutputImages();

	BOOL initOutputStreams();
	BOOL init(const char *szFile, LONG xSize, LONG ySize, BOOL videoIn, BOOL audioIn, LONG bufferSize, BOOL is_interleaved);
	BOOL finalize();
	BOOL isPreview();

	void writeIndexedChunk(FOURCC ckid, LONG dwIndexFlags, LPVOID lpBuffer, LONG cbBuffer);
};

#endif
